/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.Configuration;
import com.vistara.sdk.utils.SdkUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APITemplate
extends SdkUtil
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(APITemplate.class);
    private String apiBaseURI = null;
    private String tenantId = null;
    private String appName;
    private static APITemplate _instance = null;
    private String authType = null;
    private String apiUserName;
    private String apiPassword;

    public APITemplate(String tenantId, String uri, String authType, String key, String secretKey) throws Exception {
        this.tenantId = tenantId;
        APITemplate.getInstance();
        this.setDefaultAuth(uri, authType, key, secretKey);
        APITemplate.getInstance().setApiBaseURI(this.apiBaseURI);
        switch (this.authType) {
            case "Oauth2": {
                this.setOAUTH2Authentication(this.apiUserName, this.apiPassword);
                break;
            }
            case "Basic": {
                this.setBasicAuthentication(this.apiUserName, this.apiPassword);
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APITemplate getInstance(String tenantId) throws Exception {
        if (_instance != null) return _instance;
        Class<APITemplate> clazz = APITemplate.class;
        synchronized (APITemplate.class) {
            if (_instance != null) return _instance;
            _instance = new APITemplate(tenantId, null, null, null, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APITemplate getInstance(String tenantId, String authType) throws Exception {
        if (_instance != null) return _instance;
        Class<APITemplate> clazz = APITemplate.class;
        synchronized (APITemplate.class) {
            if (_instance != null) return _instance;
            _instance = new APITemplate(tenantId, null, authType, null, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APITemplate getInstance(String tenantId, String uri, String authType, String key, String secretKey) throws Exception {
        if (_instance != null) return _instance;
        Class<APITemplate> clazz = APITemplate.class;
        synchronized (APITemplate.class) {
            if (_instance != null) return _instance;
            _instance = new APITemplate(tenantId, uri, authType, key, secretKey);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return _instance;
        }
    }

    private String getAPIURL() throws Exception {
        String apiURL = this.apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/";
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId;
                break;
            }
            case "None": {
                apiURL = apiURL + "/integrations/" + this.tenantId + "/apps/" + this.appName;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(this.getApiUserName());
        SdkUtil.getInstance().setApiPassword(this.getApiPassword());
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        APITemplate.getInstance().setApiKey(this.getApiUserName());
        APITemplate.getInstance().setApiSecret(this.getApiPassword());
        this.setAuthType(this.authType);
        APITemplate.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication() throws Exception {
        this.authType = "None";
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public String getApiBaseURI() {
        return this.apiBaseURI;
    }

    @Override
    public void setApiBaseURI(String apiBaseURI) {
        String configApiBaseURI = null;
        try {
            configApiBaseURI = Configuration.getInstance().getConfiguration("api", "uri");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(apiBaseURI)) {
            this.apiBaseURI = apiBaseURI;
        } else if (StringUtils.isEmpty(apiBaseURI) && !StringUtils.isEmpty(configApiBaseURI)) {
            this.apiBaseURI = configApiBaseURI;
        } else if (StringUtils.isEmpty(apiBaseURI) && StringUtils.isEmpty(configApiBaseURI)) {
            this.apiBaseURI = "https://api.vistara.io";
        }
    }

    public String getAuthType() throws Exception {
        return this.authType;
    }

    public String getApiUserName() {
        return this.apiUserName;
    }

    @Override
    public void setApiUserName(String apiUserName) {
        String configUserName = null;
        try {
            configUserName = Configuration.getInstance().getConfiguration("api", "key");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty(apiUserName)) {
            this.apiUserName = configUserName;
        }
    }

    public String getApiPassword() {
        return this.apiPassword;
    }

    @Override
    public void setApiPassword(String apiPassword) {
        String configPassword = null;
        try {
            configPassword = Configuration.getInstance().getConfiguration("api", "secretKey");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty(apiPassword)) {
            this.apiPassword = configPassword;
        }
    }

    @Override
    public void setAuthType(String authType) {
        String configAuthType = null;
        try {
            configAuthType = Configuration.getInstance().getConfiguration("api", "authType");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(authType)) {
            this.authType = authType;
        } else if (StringUtils.isEmpty(authType) && !StringUtils.isEmpty(configAuthType)) {
            this.authType = configAuthType;
        } else if (StringUtils.isEmpty(authType) && StringUtils.isEmpty(configAuthType)) {
            this.authType = "Oauth2";
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setDefaultAuth(String uri, String authType, String key, String secretKey) {
        this.setAuthType(authType);
        this.setApiUserName(key);
        this.setApiPassword(secretKey);
        this.setApiBaseURI(uri);
    }

    @Override
    public String getRequest(String url) throws Exception {
        return SdkUtil.getInstance().getRequest(this.getAPIURL() + url);
    }
}

